<?php
/**
 * Conditionally load assets class
 *
 * @since 1.12
 */
class Forminator_Assets_Enqueue_Quiz extends Forminator_Assets_Enqueue {
	/**
	 * Module slug
	 *
	 * @var string
	 */
	protected static $module_slug = 'quiz';

	/**
	 * Enqueue form styles
	 *
	 * @since 1.12
	 */
	public function enqueue_styles() {
		$this->load_base_styles();

		$form_settings = $this->get_settings();
		$form_design   = isset( $form_settings['forminator-quiz-theme'] ) ? $form_settings['forminator-quiz-theme'] : '';

		if ( 'none' !== $form_design ) {

			wp_enqueue_style(
				'forminator-quiz-' . $form_design . '-base',
				forminator_plugin_url() . 'assets/forminator-ui/css/src/quiz/forminator-quiz-' . $form_design . '.base.min.css',
				array(),
				FORMINATOR_VERSION
			);
		}

		if ( isset( $form_settings['hasLeads'] ) && $form_settings['hasLeads'] ) {
			wp_enqueue_style(
				'forminator-quiz-' . $form_design . '-leads',
				forminator_plugin_url() . 'assets/forminator-ui/css/src/quiz/forminator-quiz-' . $form_design . '.leads.min.css',
				array(),
				FORMINATOR_VERSION
			);
		}
	}

	/**
	 * Enqueue scripts
	 *
	 * @since 1.11
	 */
	public function enqueue_scripts() {
		// Load form base scripts.
		$this->load_base_scripts();
	}

}
