<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package eProperty
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function eproperty_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'eproperty_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function eproperty_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'eproperty_pingback_header' );


/**
 * Add custom style for login page.
 */
function eproperty_login_style() {
	wp_enqueue_style( 'login-css', get_template_directory_uri() . '/css/theme.login.min.css' );
}
add_action( 'login_enqueue_scripts', 'eproperty_login_style' );

/**
 * Login logo URL.
 */
function eproperty_login_logo_url() {
	return home_url();
}
add_filter( 'login_headerurl', 'eproperty_login_logo_url' );

/**
 * Login logo URL title.
 */
function eproperty_login_logo_url_title() {
	return 'eProperty';
}
add_filter( 'login_headertitle', 'eproperty_login_logo_url_title' );

/**
 * Remove WP logo.
 */
function eproperty_remove_wp_logo($wp_admin_bar) {
	$wp_admin_bar->remove_node('wp-logo');
}
add_action('admin_bar_menu', 'eproperty_remove_wp_logo', 999);

/**
 * Left & right bottom credit.
 */
function eproperty_dashboard_footer_left($text) {
	return sprintf(__('<a href="https://softwareproperti.com/" title="Yekan Studio" target="_blank">Powered by eProperty</a>'), 'www.softwareproperti.com');
}
add_filter('admin_footer_text', 'eproperty_dashboard_footer_left');

function eproperty_admin_dashboard_footer_right() {
	remove_filter('update_footer', 'core_update_footer');
}
add_action('admin_menu', 'eproperty_admin_dashboard_footer_right');

/**
 * If wordpress update.
 */
function eproperty_admin_dashboard_footer() {
	if( ! current_user_can('update_core')) {
		remove_filter('update_footer', 'core_update_footer');
	}
}
add_action('admin_menu', 'eproperty_admin_dashboard_footer');

/**
 * Remove css & js version.
 */
// function eproperty_remove_wp_ver_css_js( $src ) {
// 	if ( strpos( $src, 'ver=' ) )
// 		$src = remove_query_arg( 'ver', $src );
// 	return $src;
// }
// add_filter( 'style_loader_src', 'eproperty_remove_wp_ver_css_js', 9999 );
// add_filter( 'script_loader_src', 'eproperty_remove_wp_ver_css_js', 9999 );

/**
 * Remove some junks.
 */
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'index_rel_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'feed_links_extra', 3);
remove_action('wp_head', 'start_post_rel_link', 10, 0);
remove_action('wp_head', 'parent_post_rel_link', 10, 0);
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0);
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');
remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('admin_print_styles', 'print_emoji_styles');